package com.xforceplus.ultraman.app.eccpxdomain.controller;


/**
 * 宝岛订单行feign客户端
 *
 * @author ultraman
 * @date 2021-11-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.eccpxdomain.entity.BaodaoOrderBillLine;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "eccp-x-domain")
public interface BaodaoOrderBillLineFeignApi {

  /**
   * 通过id查询宝岛订单行
   * @param  id
   * @return R
   */
  @GetMapping("/baodaoOrderBillLine/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增宝岛订单行
   * @param baodaoOrderBillLine 宝岛订单行
   * @return R
   */
  @PostMapping("/baodaoOrderBillLine/add")
  public R save(@RequestBody BaodaoOrderBillLine baodaoOrderBillLine);

  /**
   * 修改宝岛订单行
   * @param baodaoOrderBillLine 宝岛订单行
   * @return R
   */
  @PostMapping("/baodaoOrderBillLine/update")
  public R updateById(@RequestBody BaodaoOrderBillLine baodaoOrderBillLine);

  /**
   * 通过id删除宝岛订单行
   * @param  id
   * @return R
   */
  @DeleteMapping("/baodaoOrderBillLine/del/{id}" )
  public R removeById(@PathVariable Long id);

}