package com.xforceplus.ultraman.app.eccpxdomain.controller;


/**
 * 交付计划单据行feign客户端
 *
 * @author ultraman
 * @date 2021-11-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.eccpxdomain.entity.DeliverBillLine;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "eccp-x-domain")
public interface DeliverBillLineFeignApi {

  /**
   * 通过id查询交付计划单据行
   * @param  id
   * @return R
   */
  @GetMapping("/deliverBillLine/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增交付计划单据行
   * @param deliverBillLine 交付计划单据行
   * @return R
   */
  @PostMapping("/deliverBillLine/add")
  public R save(@RequestBody DeliverBillLine deliverBillLine);

  /**
   * 修改交付计划单据行
   * @param deliverBillLine 交付计划单据行
   * @return R
   */
  @PostMapping("/deliverBillLine/update")
  public R updateById(@RequestBody DeliverBillLine deliverBillLine);

  /**
   * 通过id删除交付计划单据行
   * @param  id
   * @return R
   */
  @DeleteMapping("/deliverBillLine/del/{id}" )
  public R removeById(@PathVariable Long id);

}