package com.xforceplus.ultraman.app.eccpxdomain.controller;


/**
 * 开票分次单据头feign客户端
 *
 * @author ultraman
 * @date 2021-11-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.eccpxdomain.entity.InvoiceBillHead;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "eccp-x-domain")
public interface InvoiceBillHeadFeignApi {

  /**
   * 通过id查询开票分次单据头
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceBillHead/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增开票分次单据头
   * @param invoiceBillHead 开票分次单据头
   * @return R
   */
  @PostMapping("/invoiceBillHead/add")
  public R save(@RequestBody InvoiceBillHead invoiceBillHead);

  /**
   * 修改开票分次单据头
   * @param invoiceBillHead 开票分次单据头
   * @return R
   */
  @PostMapping("/invoiceBillHead/update")
  public R updateById(@RequestBody InvoiceBillHead invoiceBillHead);

  /**
   * 通过id删除开票分次单据头
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceBillHead/del/{id}" )
  public R removeById(@PathVariable Long id);

}