package com.xforceplus.ultraman.app.eccpxdomain.controller;


/**
 * 订单头feign客户端
 *
 * @author ultraman
 * @date 2021-11-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.eccpxdomain.entity.OrderBillHead;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "eccp-x-domain")
public interface OrderBillHeadFeignApi {

  /**
   * 通过id查询订单头
   * @param  id
   * @return R
   */
  @GetMapping("/orderBillHead/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增订单头
   * @param orderBillHead 订单头
   * @return R
   */
  @PostMapping("/orderBillHead/add")
  public R save(@RequestBody OrderBillHead orderBillHead);

  /**
   * 修改订单头
   * @param orderBillHead 订单头
   * @return R
   */
  @PostMapping("/orderBillHead/update")
  public R updateById(@RequestBody OrderBillHead orderBillHead);

  /**
   * 通过id删除订单头
   * @param  id
   * @return R
   */
  @DeleteMapping("/orderBillHead/del/{id}" )
  public R removeById(@PathVariable Long id);

}