package com.xforceplus.ultraman.app.eccpxdomain.controller;


/**
 * 前置单据feign客户端
 *
 * @author ultraman
 * @date 2021-11-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.eccpxdomain.entity.PreBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "eccp-x-domain")
public interface PreBillFeignApi {

  /**
   * 通过id查询前置单据
   * @param  id
   * @return R
   */
  @GetMapping("/preBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增前置单据
   * @param preBill 前置单据
   * @return R
   */
  @PostMapping("/preBill/add")
  public R save(@RequestBody PreBill preBill);

  /**
   * 修改前置单据
   * @param preBill 前置单据
   * @return R
   */
  @PostMapping("/preBill/update")
  public R updateById(@RequestBody PreBill preBill);

  /**
   * 通过id删除前置单据
   * @param  id
   * @return R
   */
  @DeleteMapping("/preBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}