package com.xforceplus.ultraman.app.eccpxdomain.controller;


/**
 * 宝龙订单头feign客户端
 *
 * @author ultraman
 * @date 2022-10-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.eccpxdomain.entity.BaolongOrderBillhead;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "eccp-x-domain")
public interface BaolongOrderBillheadFeignApi {

  /**
   * 通过id查询宝龙订单头
   * @param  id
   * @return R
   */
  @GetMapping("/baolongOrderBillhead/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增宝龙订单头
   * @param baolongOrderBillhead 宝龙订单头
   * @return R
   */
  @PostMapping("/baolongOrderBillhead/add")
  public R save(@RequestBody BaolongOrderBillhead baolongOrderBillhead);

  /**
   * 修改宝龙订单头
   * @param baolongOrderBillhead 宝龙订单头
   * @return R
   */
  @PostMapping("/baolongOrderBillhead/update")
  public R updateById(@RequestBody BaolongOrderBillhead baolongOrderBillhead);

  /**
   * 通过id删除宝龙订单头
   * @param  id
   * @return R
   */
  @DeleteMapping("/baolongOrderBillhead/del/{id}" )
  public R removeById(@PathVariable Long id);

}