package com.xforceplus.ultraman.app.eccpxdomain.controller;


/**
 * 交付计划单据头feign客户端
 *
 * @author ultraman
 * @date 2022-10-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.eccpxdomain.entity.DeliverBillHead;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "eccp-x-domain")
public interface DeliverBillHeadFeignApi {

  /**
   * 通过id查询交付计划单据头
   * @param  id
   * @return R
   */
  @GetMapping("/deliverBillHead/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增交付计划单据头
   * @param deliverBillHead 交付计划单据头
   * @return R
   */
  @PostMapping("/deliverBillHead/add")
  public R save(@RequestBody DeliverBillHead deliverBillHead);

  /**
   * 修改交付计划单据头
   * @param deliverBillHead 交付计划单据头
   * @return R
   */
  @PostMapping("/deliverBillHead/update")
  public R updateById(@RequestBody DeliverBillHead deliverBillHead);

  /**
   * 通过id删除交付计划单据头
   * @param  id
   * @return R
   */
  @DeleteMapping("/deliverBillHead/del/{id}" )
  public R removeById(@PathVariable Long id);

}