package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2021-09-16
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.TransferOperation;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface TransferOperationFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/transferOperation/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param transferOperation ${table.comment}
   * @return R
   */
  @PostMapping("/transferOperation/add")
  public R save(@RequestBody TransferOperation transferOperation);

  /**
   * 修改${table.comment}
   * @param transferOperation ${table.comment}
   * @return R
   */
  @PostMapping("/transferOperation/update")
  public R updateById(@RequestBody TransferOperation transferOperation);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/transferOperation/del/{id}" )
  public R removeById(@PathVariable Long id);

}