package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 记账凭证feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.AccountVoucher;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface AccountVoucherFeignApi {

  /**
   * 通过id查询记账凭证
   * @param  id
   * @return R
   */
  @GetMapping("/accountVoucher/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增记账凭证
   * @param accountVoucher 记账凭证
   * @return R
   */
  @PostMapping("/accountVoucher/add")
  public R save(@RequestBody AccountVoucher accountVoucher);

  /**
   * 修改记账凭证
   * @param accountVoucher 记账凭证
   * @return R
   */
  @PostMapping("/accountVoucher/update")
  public R updateById(@RequestBody AccountVoucher accountVoucher);

  /**
   * 通过id删除记账凭证
   * @param  id
   * @return R
   */
  @DeleteMapping("/accountVoucher/del/{id}" )
  public R removeById(@PathVariable Long id);

}