package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 档案目录feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.ArchiveDirectory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface ArchiveDirectoryFeignApi {

  /**
   * 通过id查询档案目录
   * @param  id
   * @return R
   */
  @GetMapping("/archiveDirectory/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增档案目录
   * @param archiveDirectory 档案目录
   * @return R
   */
  @PostMapping("/archiveDirectory/add")
  public R save(@RequestBody ArchiveDirectory archiveDirectory);

  /**
   * 修改档案目录
   * @param archiveDirectory 档案目录
   * @return R
   */
  @PostMapping("/archiveDirectory/update")
  public R updateById(@RequestBody ArchiveDirectory archiveDirectory);

  /**
   * 通过id删除档案目录
   * @param  id
   * @return R
   */
  @DeleteMapping("/archiveDirectory/del/{id}" )
  public R removeById(@PathVariable Long id);

}