package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 档案异常信息表feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.ArchiveExceptionInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface ArchiveExceptionInfoFeignApi {

  /**
   * 通过id查询档案异常信息表
   * @param  id
   * @return R
   */
  @GetMapping("/archiveExceptionInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增档案异常信息表
   * @param archiveExceptionInfo 档案异常信息表
   * @return R
   */
  @PostMapping("/archiveExceptionInfo/add")
  public R save(@RequestBody ArchiveExceptionInfo archiveExceptionInfo);

  /**
   * 修改档案异常信息表
   * @param archiveExceptionInfo 档案异常信息表
   * @return R
   */
  @PostMapping("/archiveExceptionInfo/update")
  public R updateById(@RequestBody ArchiveExceptionInfo archiveExceptionInfo);

  /**
   * 通过id删除档案异常信息表
   * @param  id
   * @return R
   */
  @DeleteMapping("/archiveExceptionInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}