package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 三大类档案文件feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.ArchiveFile;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface ArchiveFileFeignApi {

  /**
   * 通过id查询三大类档案文件
   * @param  id
   * @return R
   */
  @GetMapping("/archiveFile/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增三大类档案文件
   * @param archiveFile 三大类档案文件
   * @return R
   */
  @PostMapping("/archiveFile/add")
  public R save(@RequestBody ArchiveFile archiveFile);

  /**
   * 修改三大类档案文件
   * @param archiveFile 三大类档案文件
   * @return R
   */
  @PostMapping("/archiveFile/update")
  public R updateById(@RequestBody ArchiveFile archiveFile);

  /**
   * 通过id删除三大类档案文件
   * @param  id
   * @return R
   */
  @DeleteMapping("/archiveFile/del/{id}" )
  public R removeById(@PathVariable Long id);

}