package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 档案对象扩展feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.ArchiveObjectExpand;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface ArchiveObjectExpandFeignApi {

  /**
   * 通过id查询档案对象扩展
   * @param  id
   * @return R
   */
  @GetMapping("/archiveObjectExpand/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增档案对象扩展
   * @param archiveObjectExpand 档案对象扩展
   * @return R
   */
  @PostMapping("/archiveObjectExpand/add")
  public R save(@RequestBody ArchiveObjectExpand archiveObjectExpand);

  /**
   * 修改档案对象扩展
   * @param archiveObjectExpand 档案对象扩展
   * @return R
   */
  @PostMapping("/archiveObjectExpand/update")
  public R updateById(@RequestBody ArchiveObjectExpand archiveObjectExpand);

  /**
   * 通过id删除档案对象扩展
   * @param  id
   * @return R
   */
  @DeleteMapping("/archiveObjectExpand/del/{id}" )
  public R removeById(@PathVariable Long id);

}