package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 附件feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.Attachement;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface AttachementFeignApi {

  /**
   * 通过id查询附件
   * @param  id
   * @return R
   */
  @GetMapping("/attachement/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增附件
   * @param attachement 附件
   * @return R
   */
  @PostMapping("/attachement/add")
  public R save(@RequestBody Attachement attachement);

  /**
   * 修改附件
   * @param attachement 附件
   * @return R
   */
  @PostMapping("/attachement/update")
  public R updateById(@RequestBody Attachement attachement);

  /**
   * 通过id删除附件
   * @param  id
   * @return R
   */
  @DeleteMapping("/attachement/del/{id}" )
  public R removeById(@PathVariable Long id);

}