package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 附件查询导入模板feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.AttachmentImport;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface AttachmentImportFeignApi {

  /**
   * 通过id查询附件查询导入模板
   * @param  id
   * @return R
   */
  @GetMapping("/attachmentImport/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增附件查询导入模板
   * @param attachmentImport 附件查询导入模板
   * @return R
   */
  @PostMapping("/attachmentImport/add")
  public R save(@RequestBody AttachmentImport attachmentImport);

  /**
   * 修改附件查询导入模板
   * @param attachmentImport 附件查询导入模板
   * @return R
   */
  @PostMapping("/attachmentImport/update")
  public R updateById(@RequestBody AttachmentImport attachmentImport);

  /**
   * 通过id删除附件查询导入模板
   * @param  id
   * @return R
   */
  @DeleteMapping("/attachmentImport/del/{id}" )
  public R removeById(@PathVariable Long id);

}