package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 单据导入查询模板feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.BillImport;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface BillImportFeignApi {

  /**
   * 通过id查询单据导入查询模板
   * @param  id
   * @return R
   */
  @GetMapping("/billImport/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增单据导入查询模板
   * @param billImport 单据导入查询模板
   * @return R
   */
  @PostMapping("/billImport/add")
  public R save(@RequestBody BillImport billImport);

  /**
   * 修改单据导入查询模板
   * @param billImport 单据导入查询模板
   * @return R
   */
  @PostMapping("/billImport/update")
  public R updateById(@RequestBody BillImport billImport);

  /**
   * 通过id删除单据导入查询模板
   * @param  id
   * @return R
   */
  @DeleteMapping("/billImport/del/{id}" )
  public R removeById(@PathVariable Long id);

}