package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 借阅申请信息feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.BorrowApplyInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface BorrowApplyInfoFeignApi {

  /**
   * 通过id查询借阅申请信息
   * @param  id
   * @return R
   */
  @GetMapping("/borrowApplyInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增借阅申请信息
   * @param borrowApplyInfo 借阅申请信息
   * @return R
   */
  @PostMapping("/borrowApplyInfo/add")
  public R save(@RequestBody BorrowApplyInfo borrowApplyInfo);

  /**
   * 修改借阅申请信息
   * @param borrowApplyInfo 借阅申请信息
   * @return R
   */
  @PostMapping("/borrowApplyInfo/update")
  public R updateById(@RequestBody BorrowApplyInfo borrowApplyInfo);

  /**
   * 通过id删除借阅申请信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/borrowApplyInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}