package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 借阅操作日志feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.BorrowOperateLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface BorrowOperateLogFeignApi {

  /**
   * 通过id查询借阅操作日志
   * @param  id
   * @return R
   */
  @GetMapping("/borrowOperateLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增借阅操作日志
   * @param borrowOperateLog 借阅操作日志
   * @return R
   */
  @PostMapping("/borrowOperateLog/add")
  public R save(@RequestBody BorrowOperateLog borrowOperateLog);

  /**
   * 修改借阅操作日志
   * @param borrowOperateLog 借阅操作日志
   * @return R
   */
  @PostMapping("/borrowOperateLog/update")
  public R updateById(@RequestBody BorrowOperateLog borrowOperateLog);

  /**
   * 通过id删除借阅操作日志
   * @param  id
   * @return R
   */
  @DeleteMapping("/borrowOperateLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}