package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 借阅资料feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.BorrowResource;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface BorrowResourceFeignApi {

  /**
   * 通过id查询借阅资料
   * @param  id
   * @return R
   */
  @GetMapping("/borrowResource/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增借阅资料
   * @param borrowResource 借阅资料
   * @return R
   */
  @PostMapping("/borrowResource/add")
  public R save(@RequestBody BorrowResource borrowResource);

  /**
   * 修改借阅资料
   * @param borrowResource 借阅资料
   * @return R
   */
  @PostMapping("/borrowResource/update")
  public R updateById(@RequestBody BorrowResource borrowResource);

  /**
   * 通过id删除借阅资料
   * @param  id
   * @return R
   */
  @DeleteMapping("/borrowResource/del/{id}" )
  public R removeById(@PathVariable Long id);

}