package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 资料类型配置feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.ConfigAccountDataType;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface ConfigAccountDataTypeFeignApi {

  /**
   * 通过id查询资料类型配置
   * @param  id
   * @return R
   */
  @GetMapping("/configAccountDataType/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增资料类型配置
   * @param configAccountDataType 资料类型配置
   * @return R
   */
  @PostMapping("/configAccountDataType/add")
  public R save(@RequestBody ConfigAccountDataType configAccountDataType);

  /**
   * 修改资料类型配置
   * @param configAccountDataType 资料类型配置
   * @return R
   */
  @PostMapping("/configAccountDataType/update")
  public R updateById(@RequestBody ConfigAccountDataType configAccountDataType);

  /**
   * 通过id删除资料类型配置
   * @param  id
   * @return R
   */
  @DeleteMapping("/configAccountDataType/del/{id}" )
  public R removeById(@PathVariable Long id);

}