package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 类型配置feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.ConfigArchivesType;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface ConfigArchivesTypeFeignApi {

  /**
   * 通过id查询类型配置
   * @param  id
   * @return R
   */
  @GetMapping("/configArchivesType/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增类型配置
   * @param configArchivesType 类型配置
   * @return R
   */
  @PostMapping("/configArchivesType/add")
  public R save(@RequestBody ConfigArchivesType configArchivesType);

  /**
   * 修改类型配置
   * @param configArchivesType 类型配置
   * @return R
   */
  @PostMapping("/configArchivesType/update")
  public R updateById(@RequestBody ConfigArchivesType configArchivesType);

  /**
   * 通过id删除类型配置
   * @param  id
   * @return R
   */
  @DeleteMapping("/configArchivesType/del/{id}" )
  public R removeById(@PathVariable Long id);

}