package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 系统配置feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.ConfigSettings;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface ConfigSettingsFeignApi {

  /**
   * 通过id查询系统配置
   * @param  id
   * @return R
   */
  @GetMapping("/configSettings/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统配置
   * @param configSettings 系统配置
   * @return R
   */
  @PostMapping("/configSettings/add")
  public R save(@RequestBody ConfigSettings configSettings);

  /**
   * 修改系统配置
   * @param configSettings 系统配置
   * @return R
   */
  @PostMapping("/configSettings/update")
  public R updateById(@RequestBody ConfigSettings configSettings);

  /**
   * 通过id删除系统配置
   * @param  id
   * @return R
   */
  @DeleteMapping("/configSettings/del/{id}" )
  public R removeById(@PathVariable Long id);

}