package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 四性检测feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.Detection;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface DetectionFeignApi {

  /**
   * 通过id查询四性检测
   * @param  id
   * @return R
   */
  @GetMapping("/detection/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增四性检测
   * @param detection 四性检测
   * @return R
   */
  @PostMapping("/detection/add")
  public R save(@RequestBody Detection detection);

  /**
   * 修改四性检测
   * @param detection 四性检测
   * @return R
   */
  @PostMapping("/detection/update")
  public R updateById(@RequestBody Detection detection);

  /**
   * 通过id删除四性检测
   * @param  id
   * @return R
   */
  @DeleteMapping("/detection/del/{id}" )
  public R removeById(@PathVariable Long id);

}