package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 影像feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.Image;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface ImageFeignApi {

  /**
   * 通过id查询影像
   * @param  id
   * @return R
   */
  @GetMapping("/image/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增影像
   * @param image 影像
   * @return R
   */
  @PostMapping("/image/add")
  public R save(@RequestBody Image image);

  /**
   * 修改影像
   * @param image 影像
   * @return R
   */
  @PostMapping("/image/update")
  public R updateById(@RequestBody Image image);

  /**
   * 通过id删除影像
   * @param  id
   * @return R
   */
  @DeleteMapping("/image/del/{id}" )
  public R removeById(@PathVariable Long id);

}