package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 盘点结果表feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.InventoryResult;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface InventoryResultFeignApi {

  /**
   * 通过id查询盘点结果表
   * @param  id
   * @return R
   */
  @GetMapping("/inventoryResult/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增盘点结果表
   * @param inventoryResult 盘点结果表
   * @return R
   */
  @PostMapping("/inventoryResult/add")
  public R save(@RequestBody InventoryResult inventoryResult);

  /**
   * 修改盘点结果表
   * @param inventoryResult 盘点结果表
   * @return R
   */
  @PostMapping("/inventoryResult/update")
  public R updateById(@RequestBody InventoryResult inventoryResult);

  /**
   * 通过id删除盘点结果表
   * @param  id
   * @return R
   */
  @DeleteMapping("/inventoryResult/del/{id}" )
  public R removeById(@PathVariable Long id);

}