package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 库位信息组织feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.Location;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface LocationFeignApi {

  /**
   * 通过id查询库位信息组织
   * @param  id
   * @return R
   */
  @GetMapping("/location/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增库位信息组织
   * @param location 库位信息组织
   * @return R
   */
  @PostMapping("/location/add")
  public R save(@RequestBody Location location);

  /**
   * 修改库位信息组织
   * @param location 库位信息组织
   * @return R
   */
  @PostMapping("/location/update")
  public R updateById(@RequestBody Location location);

  /**
   * 通过id删除库位信息组织
   * @param  id
   * @return R
   */
  @DeleteMapping("/location/del/{id}" )
  public R removeById(@PathVariable Long id);

}