package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 库位feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.LocationOrg;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface LocationOrgFeignApi {

  /**
   * 通过id查询库位
   * @param  id
   * @return R
   */
  @GetMapping("/locationOrg/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增库位
   * @param locationOrg 库位
   * @return R
   */
  @PostMapping("/locationOrg/add")
  public R save(@RequestBody LocationOrg locationOrg);

  /**
   * 修改库位
   * @param locationOrg 库位
   * @return R
   */
  @PostMapping("/locationOrg/update")
  public R updateById(@RequestBody LocationOrg locationOrg);

  /**
   * 通过id删除库位
   * @param  id
   * @return R
   */
  @DeleteMapping("/locationOrg/del/{id}" )
  public R removeById(@PathVariable Long id);

}