package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 原始单据feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.OriginalBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface OriginalBillFeignApi {

  /**
   * 通过id查询原始单据
   * @param  id
   * @return R
   */
  @GetMapping("/originalBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增原始单据
   * @param originalBill 原始单据
   * @return R
   */
  @PostMapping("/originalBill/add")
  public R save(@RequestBody OriginalBill originalBill);

  /**
   * 修改原始单据
   * @param originalBill 原始单据
   * @return R
   */
  @PostMapping("/originalBill/update")
  public R updateById(@RequestBody OriginalBill originalBill);

  /**
   * 通过id删除原始单据
   * @param  id
   * @return R
   */
  @DeleteMapping("/originalBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}