package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 原始单证feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.OriginalTicket;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface OriginalTicketFeignApi {

  /**
   * 通过id查询原始单证
   * @param  id
   * @return R
   */
  @GetMapping("/originalTicket/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增原始单证
   * @param originalTicket 原始单证
   * @return R
   */
  @PostMapping("/originalTicket/add")
  public R save(@RequestBody OriginalTicket originalTicket);

  /**
   * 修改原始单证
   * @param originalTicket 原始单证
   * @return R
   */
  @PostMapping("/originalTicket/update")
  public R updateById(@RequestBody OriginalTicket originalTicket);

  /**
   * 通过id删除原始单证
   * @param  id
   * @return R
   */
  @DeleteMapping("/originalTicket/del/{id}" )
  public R removeById(@PathVariable Long id);

}