package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 外包商feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.Outsourcers;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface OutsourcersFeignApi {

  /**
   * 通过id查询外包商
   * @param  id
   * @return R
   */
  @GetMapping("/outsourcers/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增外包商
   * @param outsourcers 外包商
   * @return R
   */
  @PostMapping("/outsourcers/add")
  public R save(@RequestBody Outsourcers outsourcers);

  /**
   * 修改外包商
   * @param outsourcers 外包商
   * @return R
   */
  @PostMapping("/outsourcers/update")
  public R updateById(@RequestBody Outsourcers outsourcers);

  /**
   * 通过id删除外包商
   * @param  id
   * @return R
   */
  @DeleteMapping("/outsourcers/del/{id}" )
  public R removeById(@PathVariable Long id);

}