package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 待入库导入查询模板feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.StorageImport;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface StorageImportFeignApi {

  /**
   * 通过id查询待入库导入查询模板
   * @param  id
   * @return R
   */
  @GetMapping("/storageImport/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增待入库导入查询模板
   * @param storageImport 待入库导入查询模板
   * @return R
   */
  @PostMapping("/storageImport/add")
  public R save(@RequestBody StorageImport storageImport);

  /**
   * 修改待入库导入查询模板
   * @param storageImport 待入库导入查询模板
   * @return R
   */
  @PostMapping("/storageImport/update")
  public R updateById(@RequestBody StorageImport storageImport);

  /**
   * 通过id删除待入库导入查询模板
   * @param  id
   * @return R
   */
  @DeleteMapping("/storageImport/del/{id}" )
  public R removeById(@PathVariable Long id);

}