package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 公交车车票feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.TicketBus;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface TicketBusFeignApi {

  /**
   * 通过id查询公交车车票
   * @param  id
   * @return R
   */
  @GetMapping("/ticketBus/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增公交车车票
   * @param ticketBus 公交车车票
   * @return R
   */
  @PostMapping("/ticketBus/add")
  public R save(@RequestBody TicketBus ticketBus);

  /**
   * 修改公交车车票
   * @param ticketBus 公交车车票
   * @return R
   */
  @PostMapping("/ticketBus/update")
  public R updateById(@RequestBody TicketBus ticketBus);

  /**
   * 通过id删除公交车车票
   * @param  id
   * @return R
   */
  @DeleteMapping("/ticketBus/del/{id}" )
  public R removeById(@PathVariable Long id);

}