package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 增值税发票feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.TicketInvoice;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface TicketInvoiceFeignApi {

  /**
   * 通过id查询增值税发票
   * @param  id
   * @return R
   */
  @GetMapping("/ticketInvoice/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增增值税发票
   * @param ticketInvoice 增值税发票
   * @return R
   */
  @PostMapping("/ticketInvoice/add")
  public R save(@RequestBody TicketInvoice ticketInvoice);

  /**
   * 修改增值税发票
   * @param ticketInvoice 增值税发票
   * @return R
   */
  @PostMapping("/ticketInvoice/update")
  public R updateById(@RequestBody TicketInvoice ticketInvoice);

  /**
   * 通过id删除增值税发票
   * @param  id
   * @return R
   */
  @DeleteMapping("/ticketInvoice/del/{id}" )
  public R removeById(@PathVariable Long id);

}