package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 发票导入查询模板feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.TicketInvoiceImport;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface TicketInvoiceImportFeignApi {

  /**
   * 通过id查询发票导入查询模板
   * @param  id
   * @return R
   */
  @GetMapping("/ticketInvoiceImport/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票导入查询模板
   * @param ticketInvoiceImport 发票导入查询模板
   * @return R
   */
  @PostMapping("/ticketInvoiceImport/add")
  public R save(@RequestBody TicketInvoiceImport ticketInvoiceImport);

  /**
   * 修改发票导入查询模板
   * @param ticketInvoiceImport 发票导入查询模板
   * @return R
   */
  @PostMapping("/ticketInvoiceImport/update")
  public R updateById(@RequestBody TicketInvoiceImport ticketInvoiceImport);

  /**
   * 通过id删除发票导入查询模板
   * @param  id
   * @return R
   */
  @DeleteMapping("/ticketInvoiceImport/del/{id}" )
  public R removeById(@PathVariable Long id);

}