package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 通用机打明细 feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.TicketMachineDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface TicketMachineDetailFeignApi {

  /**
   * 通过id查询通用机打明细 
   * @param  id
   * @return R
   */
  @GetMapping("/ticketMachineDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增通用机打明细 
   * @param ticketMachineDetail 通用机打明细 
   * @return R
   */
  @PostMapping("/ticketMachineDetail/add")
  public R save(@RequestBody TicketMachineDetail ticketMachineDetail);

  /**
   * 修改通用机打明细 
   * @param ticketMachineDetail 通用机打明细 
   * @return R
   */
  @PostMapping("/ticketMachineDetail/update")
  public R updateById(@RequestBody TicketMachineDetail ticketMachineDetail);

  /**
   * 通过id删除通用机打明细 
   * @param  id
   * @return R
   */
  @DeleteMapping("/ticketMachineDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}