package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 定额发票feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.TicketQuota;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface TicketQuotaFeignApi {

  /**
   * 通过id查询定额发票
   * @param  id
   * @return R
   */
  @GetMapping("/ticketQuota/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增定额发票
   * @param ticketQuota 定额发票
   * @return R
   */
  @PostMapping("/ticketQuota/add")
  public R save(@RequestBody TicketQuota ticketQuota);

  /**
   * 修改定额发票
   * @param ticketQuota 定额发票
   * @return R
   */
  @PostMapping("/ticketQuota/update")
  public R updateById(@RequestBody TicketQuota ticketQuota);

  /**
   * 通过id删除定额发票
   * @param  id
   * @return R
   */
  @DeleteMapping("/ticketQuota/del/{id}" )
  public R removeById(@PathVariable Long id);

}