package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 出租车发票feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.TicketTaxi;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface TicketTaxiFeignApi {

  /**
   * 通过id查询出租车发票
   * @param  id
   * @return R
   */
  @GetMapping("/ticketTaxi/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增出租车发票
   * @param ticketTaxi 出租车发票
   * @return R
   */
  @PostMapping("/ticketTaxi/add")
  public R save(@RequestBody TicketTaxi ticketTaxi);

  /**
   * 修改出租车发票
   * @param ticketTaxi 出租车发票
   * @return R
   */
  @PostMapping("/ticketTaxi/update")
  public R updateById(@RequestBody TicketTaxi ticketTaxi);

  /**
   * 通过id删除出租车发票
   * @param  id
   * @return R
   */
  @DeleteMapping("/ticketTaxi/del/{id}" )
  public R removeById(@PathVariable Long id);

}