package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 过路费发票feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.TicketToll;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface TicketTollFeignApi {

  /**
   * 通过id查询过路费发票
   * @param  id
   * @return R
   */
  @GetMapping("/ticketToll/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增过路费发票
   * @param ticketToll 过路费发票
   * @return R
   */
  @PostMapping("/ticketToll/add")
  public R save(@RequestBody TicketToll ticketToll);

  /**
   * 修改过路费发票
   * @param ticketToll 过路费发票
   * @return R
   */
  @PostMapping("/ticketToll/update")
  public R updateById(@RequestBody TicketToll ticketToll);

  /**
   * 通过id删除过路费发票
   * @param  id
   * @return R
   */
  @DeleteMapping("/ticketToll/del/{id}" )
  public R removeById(@PathVariable Long id);

}