package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 火车票feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.TicketTrain;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface TicketTrainFeignApi {

  /**
   * 通过id查询火车票
   * @param  id
   * @return R
   */
  @GetMapping("/ticketTrain/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增火车票
   * @param ticketTrain 火车票
   * @return R
   */
  @PostMapping("/ticketTrain/add")
  public R save(@RequestBody TicketTrain ticketTrain);

  /**
   * 修改火车票
   * @param ticketTrain 火车票
   * @return R
   */
  @PostMapping("/ticketTrain/update")
  public R updateById(@RequestBody TicketTrain ticketTrain);

  /**
   * 通过id删除火车票
   * @param  id
   * @return R
   */
  @DeleteMapping("/ticketTrain/del/{id}" )
  public R removeById(@PathVariable Long id);

}