package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 转移操作表feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.TransferOperation;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface TransferOperationFeignApi {

  /**
   * 通过id查询转移操作表
   * @param  id
   * @return R
   */
  @GetMapping("/transferOperation/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增转移操作表
   * @param transferOperation 转移操作表
   * @return R
   */
  @PostMapping("/transferOperation/add")
  public R save(@RequestBody TransferOperation transferOperation);

  /**
   * 修改转移操作表
   * @param transferOperation 转移操作表
   * @return R
   */
  @PostMapping("/transferOperation/update")
  public R updateById(@RequestBody TransferOperation transferOperation);

  /**
   * 通过id删除转移操作表
   * @param  id
   * @return R
   */
  @DeleteMapping("/transferOperation/del/{id}" )
  public R removeById(@PathVariable Long id);

}