package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 档案鉴定申请单feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.VolumeAppraisalApply;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface VolumeAppraisalApplyFeignApi {

  /**
   * 通过id查询档案鉴定申请单
   * @param  id
   * @return R
   */
  @GetMapping("/volumeAppraisalApply/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增档案鉴定申请单
   * @param volumeAppraisalApply 档案鉴定申请单
   * @return R
   */
  @PostMapping("/volumeAppraisalApply/add")
  public R save(@RequestBody VolumeAppraisalApply volumeAppraisalApply);

  /**
   * 修改档案鉴定申请单
   * @param volumeAppraisalApply 档案鉴定申请单
   * @return R
   */
  @PostMapping("/volumeAppraisalApply/update")
  public R updateById(@RequestBody VolumeAppraisalApply volumeAppraisalApply);

  /**
   * 通过id删除档案鉴定申请单
   * @param  id
   * @return R
   */
  @DeleteMapping("/volumeAppraisalApply/del/{id}" )
  public R removeById(@PathVariable Long id);

}