package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 档案鉴定申请关系feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.VolumeAppraisalRelation;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface VolumeAppraisalRelationFeignApi {

  /**
   * 通过id查询档案鉴定申请关系
   * @param  id
   * @return R
   */
  @GetMapping("/volumeAppraisalRelation/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增档案鉴定申请关系
   * @param volumeAppraisalRelation 档案鉴定申请关系
   * @return R
   */
  @PostMapping("/volumeAppraisalRelation/add")
  public R save(@RequestBody VolumeAppraisalRelation volumeAppraisalRelation);

  /**
   * 修改档案鉴定申请关系
   * @param volumeAppraisalRelation 档案鉴定申请关系
   * @return R
   */
  @PostMapping("/volumeAppraisalRelation/update")
  public R updateById(@RequestBody VolumeAppraisalRelation volumeAppraisalRelation);

  /**
   * 通过id删除档案鉴定申请关系
   * @param  id
   * @return R
   */
  @DeleteMapping("/volumeAppraisalRelation/del/{id}" )
  public R removeById(@PathVariable Long id);

}