package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 分册实体feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.Volume;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface VolumeFeignApi {

  /**
   * 通过id查询分册实体
   * @param  id
   * @return R
   */
  @GetMapping("/volume/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增分册实体
   * @param volume 分册实体
   * @return R
   */
  @PostMapping("/volume/add")
  public R save(@RequestBody Volume volume);

  /**
   * 修改分册实体
   * @param volume 分册实体
   * @return R
   */
  @PostMapping("/volume/update")
  public R updateById(@RequestBody Volume volume);

  /**
   * 通过id删除分册实体
   * @param  id
   * @return R
   */
  @DeleteMapping("/volume/del/{id}" )
  public R removeById(@PathVariable Long id);

}