package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 待分册导入查询模板feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.VolumeImport;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface VolumeImportFeignApi {

  /**
   * 通过id查询待分册导入查询模板
   * @param  id
   * @return R
   */
  @GetMapping("/volumeImport/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增待分册导入查询模板
   * @param volumeImport 待分册导入查询模板
   * @return R
   */
  @PostMapping("/volumeImport/add")
  public R save(@RequestBody VolumeImport volumeImport);

  /**
   * 修改待分册导入查询模板
   * @param volumeImport 待分册导入查询模板
   * @return R
   */
  @PostMapping("/volumeImport/update")
  public R updateById(@RequestBody VolumeImport volumeImport);

  /**
   * 通过id删除待分册导入查询模板
   * @param  id
   * @return R
   */
  @DeleteMapping("/volumeImport/del/{id}" )
  public R removeById(@PathVariable Long id);

}