package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 拆册记录feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.VolumePartitionRecord;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface VolumePartitionRecordFeignApi {

  /**
   * 通过id查询拆册记录
   * @param  id
   * @return R
   */
  @GetMapping("/volumePartitionRecord/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增拆册记录
   * @param volumePartitionRecord 拆册记录
   * @return R
   */
  @PostMapping("/volumePartitionRecord/add")
  public R save(@RequestBody VolumePartitionRecord volumePartitionRecord);

  /**
   * 修改拆册记录
   * @param volumePartitionRecord 拆册记录
   * @return R
   */
  @PostMapping("/volumePartitionRecord/update")
  public R updateById(@RequestBody VolumePartitionRecord volumePartitionRecord);

  /**
   * 通过id删除拆册记录
   * @param  id
   * @return R
   */
  @DeleteMapping("/volumePartitionRecord/del/{id}" )
  public R removeById(@PathVariable Long id);

}