package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 分册提交记录feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.VolumeSubmitRecord;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface VolumeSubmitRecordFeignApi {

  /**
   * 通过id查询分册提交记录
   * @param  id
   * @return R
   */
  @GetMapping("/volumeSubmitRecord/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增分册提交记录
   * @param volumeSubmitRecord 分册提交记录
   * @return R
   */
  @PostMapping("/volumeSubmitRecord/add")
  public R save(@RequestBody VolumeSubmitRecord volumeSubmitRecord);

  /**
   * 修改分册提交记录
   * @param volumeSubmitRecord 分册提交记录
   * @return R
   */
  @PostMapping("/volumeSubmitRecord/update")
  public R updateById(@RequestBody VolumeSubmitRecord volumeSubmitRecord);

  /**
   * 通过id删除分册提交记录
   * @param  id
   * @return R
   */
  @DeleteMapping("/volumeSubmitRecord/del/{id}" )
  public R removeById(@PathVariable Long id);

}