package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 凭证分录(凭证明细)feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.VoucherItem;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface VoucherItemFeignApi {

  /**
   * 通过id查询凭证分录(凭证明细)
   * @param  id
   * @return R
   */
  @GetMapping("/voucherItem/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增凭证分录(凭证明细)
   * @param voucherItem 凭证分录(凭证明细)
   * @return R
   */
  @PostMapping("/voucherItem/add")
  public R save(@RequestBody VoucherItem voucherItem);

  /**
   * 修改凭证分录(凭证明细)
   * @param voucherItem 凭证分录(凭证明细)
   * @return R
   */
  @PostMapping("/voucherItem/update")
  public R updateById(@RequestBody VoucherItem voucherItem);

  /**
   * 通过id删除凭证分录(凭证明细)
   * @param  id
   * @return R
   */
  @DeleteMapping("/voucherItem/del/{id}" )
  public R removeById(@PathVariable Long id);

}