package com.xforceplus.ultraman.app.elephantarchives.controller;


/**
 * 档案管理室feign客户端
 *
 * @author ultraman
 * @date 2021-11-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.Warehouse;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant-archives")
public interface WarehouseFeignApi {

  /**
   * 通过id查询档案管理室
   * @param  id
   * @return R
   */
  @GetMapping("/warehouse/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增档案管理室
   * @param warehouse 档案管理室
   * @return R
   */
  @PostMapping("/warehouse/add")
  public R save(@RequestBody Warehouse warehouse);

  /**
   * 修改档案管理室
   * @param warehouse 档案管理室
   * @return R
   */
  @PostMapping("/warehouse/update")
  public R updateById(@RequestBody Warehouse warehouse);

  /**
   * 通过id删除档案管理室
   * @param  id
   * @return R
   */
  @DeleteMapping("/warehouse/del/{id}" )
  public R removeById(@PathVariable Long id);

}