package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 样式大类
 * </p>
 *
 * @author ultraman
 * @since 2021-08-10
 */
public enum StyleLargeType {

    COVER_A("coverA", "记账凭证"),
    COVER_B("coverB", "凭证封面"),
    PROCESS_FORM("processForm", "流程追溯表");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StyleLargeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StyleLargeType fromCode(String code){
        switch(code) {
            case "coverA":
                return COVER_A;
            case "coverB":
                return COVER_B;
            case "processForm":
                return PROCESS_FORM;
            default:
                return null;
        }
    }
}
