package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 分册状态
 * </p>
 *
 * @author ultraman
 * @since 2021-08-10
 */
public enum VolumeStatus {

    _0("0", "待接收"),
    _1("1", "待分册"),
    _2("2", "已分册"),
    _4("4", "待整理"),
    _5("5", "已整理"),
    _3("3", "待办");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VolumeStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VolumeStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "4":
                return _4;
            case "5":
                return _5;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
